<?php

namespace App\Http\Controllers;

use App\Models\Testtube;
use Carbon\Carbon;
use Illuminate\Http\Request;

class TesttubeController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:api');
    }
    /**
     * @OA\Post(
     *     path="/api/testtube/getlist",
     *     operationId="TesttubeList",
     *     tags={"Protected Routes"},
     *     summary="Get List of Testtube",
     *     description="This route requires authentication. Retrieves a list of Testtube with details on added, updated, and deleted items.",
     *     security={{"bearerAuth": {}}},
     *     @OA\RequestBody(
     *         required=true,
     *         description="User credentials",
     *         @OA\JsonContent(
     *             @OA\Property(property="timestamp", type="string", format="timestamp", example=1828384884)
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Successful response",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="success", type="boolean", example=true),
     *             @OA\Property(property="added", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="tube_name", type="string", example="LAV/BLK"),
     *                     @OA\Property(property="tube_color", type="string", example="LAV/BLK"),
     *                     @OA\Property(property="spid_validation", type="string", example="LK,TS"),
     *                     @OA\Property(property="tube_size", type="string", example="4"),
     *                     @OA\Property(property="tube_additive", type="string", example=""),
     *                     @OA\Property(property="tube_inversions", type="string", example=""),
     *                     @OA\Property(property="tube_warning", type="string", example=""),
     *                     @OA\Property(property="tube_description", type="string", example=""),
     *                     @OA\Property(property="tube_notes", type="string", example=""),
     *                     @OA\Property(property="status", type="integer", example=1),
     *                     @OA\Property(property="spid_validation_cron_status", type="integer", example=0),
     *                     @OA\Property(property="created_at", type="string", example="2022-03-18T05:50:14.000000Z"),
     *                     @OA\Property(property="updated_at", type="string", example="2022-12-20T12:05:41.000000Z"),
     *                     @OA\Property(property="subscriber_id", type="integer", nullable=true),
     *                     @OA\Property(property="delete_by", type="integer", nullable=true),
     *                     @OA\Property(property="deleted_at", type="integer", example=0),
     *                 ),
     *             ),
     *             @OA\Property(property="updated", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="tube_name", type="string", example="LAV/BLK"),
     *                     @OA\Property(property="tube_color", type="string", example="LAV/BLK"),
     *                     @OA\Property(property="spid_validation", type="string", example="LK,TS"),
     *                     @OA\Property(property="tube_size", type="string", example="4"),
     *                     @OA\Property(property="tube_additive", type="string", example=""),
     *                     @OA\Property(property="tube_inversions", type="string", example=""),
     *                     @OA\Property(property="tube_warning", type="string", example=""),
     *                     @OA\Property(property="tube_description", type="string", example=""),
     *                     @OA\Property(property="tube_notes", type="string", example=""),
     *                     @OA\Property(property="status", type="integer", example=1),
     *                     @OA\Property(property="spid_validation_cron_status", type="integer", example=0),
     *                     @OA\Property(property="created_at", type="string", example="2022-03-18T05:50:14.000000Z"),
     *                     @OA\Property(property="updated_at", type="string", example="2022-12-20T12:05:41.000000Z"),
     *                     @OA\Property(property="subscriber_id", type="integer", nullable=true),
     *                     @OA\Property(property="delete_by", type="integer", nullable=true),
     *                     @OA\Property(property="deleted_at", type="integer", example=0),
     *                 ),
     *             ),
     *             @OA\Property(property="deleted", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="tube_name", type="string", example="LAV/BLK"),
     *                     @OA\Property(property="tube_color", type="string", example="LAV/BLK"),
     *                     @OA\Property(property="spid_validation", type="string", example="LK,TS"),
     *                     @OA\Property(property="tube_size", type="string", example="4"),
     *                     @OA\Property(property="tube_additive", type="string", example=""),
     *                     @OA\Property(property="tube_inversions", type="string", example=""),
     *                     @OA\Property(property="tube_warning", type="string", example=""),
     *                     @OA\Property(property="tube_description", type="string", example=""),
     *                     @OA\Property(property="tube_notes", type="string", example=""),
     *                     @OA\Property(property="status", type="integer", example=1),
     *                     @OA\Property(property="spid_validation_cron_status", type="integer", example=0),
     *                     @OA\Property(property="created_at", type="string", example="2022-03-18T05:50:14.000000Z"),
     *                     @OA\Property(property="updated_at", type="string", example="2022-12-20T12:05:41.000000Z"),
     *                     @OA\Property(property="subscriber_id", type="integer", nullable=true),
     *                     @OA\Property(property="delete_by", type="integer", nullable=true),
     *                     @OA\Property(property="deleted_at", type="integer", example=0),
     *                 ),
     *             ),
     *         ),
     *     ),
     * )
     */
    public function getList(Request $request){
        $currentTimeStamp = $request->timestamp ? Carbon::createFromTimestamp($request->timestamp)->format('Y-m-d') : null;
        $added = [];
        $updated = [];
        $deleted = [];
        if($currentTimeStamp){
            // spid_validation not found
            // spid_validation_cron_status not found
            // whereNull('deleted_at')
            // whereNotNull('deleted_at')
            $added = Testtube::whereNull('deleted_at')->whereDate('created_at','>=',$currentTimeStamp)->get(['testtube_id','tube_name','tube_color','tube_size','tube_additive','tube_inversions','tube_warning','tube_description','tube_notes','status','created_at','updated_at','subscriber_id','delete_by','deleted_at']);
            $addedIDs = $added->pluck('testtube_id')->toArray();
            $updated = Testtube::whereNotIn('testtube_id',$addedIDs)->whereNull('deleted_at')->whereDate('updated_at','>=',$currentTimeStamp)->get(['testtube_id','tube_name','tube_color','tube_size','tube_additive','tube_inversions','tube_warning','tube_description','tube_notes','status','created_at','updated_at','subscriber_id','delete_by','deleted_at']);
            $deleted = Testtube::whereNotNull('deleted_at')->whereDate('updated_at','>=',$currentTimeStamp)->get(['testtube_id','tube_name','tube_color','tube_size','tube_additive','tube_inversions','tube_warning','tube_description','tube_notes','status','created_at','updated_at','subscriber_id','delete_by','deleted_at']);
        }else{
            $added = Testtube::whereNull('deleted_at')->get(['testtube_id','tube_name','tube_color','tube_size','tube_additive','tube_inversions','tube_warning','tube_description','tube_notes','status','created_at','updated_at','subscriber_id','delete_by','deleted_at']);
            $deleted = Testtube::whereNotNull('deleted_at')->get(['testtube_id','tube_name','tube_color','tube_size','tube_additive','tube_inversions','tube_warning','tube_description','tube_notes','status','created_at','updated_at','subscriber_id','delete_by','deleted_at']);
        }
        return ['success'=>true,"added"=>$added, "updated"=>$updated, "deleted"=>$deleted];
    }
}
