<?php

namespace App\Http\Controllers;

use App\Models\Technician;
use App\Repositories\PushNotificationRepository;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class TechnicianController extends Controller
{
    public function __construct()
    {
     //   $this->middleware('auth:api');
    }
    /**
     * @OA\Post(
     *     path="/api/technician/getlist",
     *     operationId="TechnicianList",
     *     tags={"Protected Routes"},
     *     summary="Get List of Technician",
     *     description="This route requires authentication. Retrieves a list of Technician with details on added, updated, and deleted items.",
     *     security={{"bearerAuth": {}}},
     *     @OA\RequestBody(
     *         required=true,
     *         description="User credentials",
     *         @OA\JsonContent(
     *             @OA\Property(property="timestamp", type="string", format="timestamp", example=1828384884)
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Successful response",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="success", type="boolean", example=true),
     *             @OA\Property(property="added", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="tech_userid", type="integer", example=117),
     *                     @OA\Property(property="tech_first_name", type="string", example="Janet"),
     *                     @OA\Property(property="tech_last_name", type="string", example="Needlepro"),
     *                     @OA\Property(property="tech_middle_name", type="string", nullable=true),
     *                     @OA\Property(property="tech_name", type="string", example="Janet Needlepro"),
     *                     @OA\Property(property="tech_phlebio_id", type="integer", nullable=true),
     *                     @OA\Property(property="tech_bkg_chk", type="integer", example=1),
     *                     @OA\Property(property="tech_bkg_chk_date", type="string", example="2021-02-28 09:53:00"),
     *                     @OA\Property(property="tech_state_cert", type="integer", example=7),
     *                     @OA\Property(property="tech_cert_num", type="string", example="2007"),
     *                     @OA\Property(property="tech_cert_level", type="integer", example=1),
     *                     @OA\Property(property="tech_cert_exp", type="string", example="2021-03-28 09:53:00"),
     *                     @OA\Property(property="tech_subscriber_id", type="integer", nullable=true),
     *                     @OA\Property(property="tech_svc_area", type="string", example="45.323338,-93.14105 , 45.110515,-91.872129 , 44.623863,-92.679624 , 44.619953,-93.706846 , 44.994093,-94.278135 , 45.238304,-93.866147 ,"),
     *                     @OA\Property(property="tech_username", type="string", nullable=true),
     *                     @OA\Property(property="tech_pass", type="string", nullable=true),
     *                     @OA\Property(property="tech_email", type="string", example="mkcsinfotech@phlebio.com"),
     *                     @OA\Property(property="tech_cell_phone", type="string", example="123654789"),
     *                     @OA\Property(property="tech_street", type="string", example="45 West 10th Street"),
     *                     @OA\Property(property="tech_city", type="string", example="Saint Paul"),
     *                     @OA\Property(property="tech_state", type="string", example="Minnesota"),
     *                     @OA\Property(property="tech_zip", type="string", example="55102"),
     *                     @OA\Property(property="tech_warning", type="string", example="Special"),
     *                     @OA\Property(property="tech_notes", type="string", example="best notes"),
     *                     @OA\Property(property="status", type="integer", example=1),
     *                     @OA\Property(property="service_hubid", type="integer", example=1),
     *                     @OA\Property(property="subscriber_id", type="integer", example=0),
     *                     @OA\Property(property="tech_profileimage", type="string", example="1620911292.png"),
     *                     @OA\Property(property="deleted_at", type="integer", example=0),
     *                     @OA\Property(property="is_supervisor", type="integer", example=0),
     *                     @OA\Property(property="hub_name", type="string", example="Demo Service Hub One"),
     *                 ),
     *             ),
     *             @OA\Property(property="updated", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="tech_userid", type="integer", example=117),
     *                     @OA\Property(property="tech_first_name", type="string", example="Janet"),
     *                     @OA\Property(property="tech_last_name", type="string", example="Needlepro"),
     *                     @OA\Property(property="tech_middle_name", type="string", nullable=true),
     *                     @OA\Property(property="tech_name", type="string", example="Janet Needlepro"),
     *                     @OA\Property(property="tech_phlebio_id", type="integer", nullable=true),
     *                     @OA\Property(property="tech_bkg_chk", type="integer", example=1),
     *                     @OA\Property(property="tech_bkg_chk_date", type="string", example="2021-02-28 09:53:00"),
     *                     @OA\Property(property="tech_state_cert", type="integer", example=7),
     *                     @OA\Property(property="tech_cert_num", type="string", example="2007"),
     *                     @OA\Property(property="tech_cert_level", type="integer", example=1),
     *                     @OA\Property(property="tech_cert_exp", type="string", example="2021-03-28 09:53:00"),
     *                     @OA\Property(property="tech_subscriber_id", type="integer", nullable=true),
     *                     @OA\Property(property="tech_svc_area", type="string", example="45.323338,-93.14105 , 45.110515,-91.872129 , 44.623863,-92.679624 , 44.619953,-93.706846 , 44.994093,-94.278135 , 45.238304,-93.866147 ,"),
     *                     @OA\Property(property="tech_username", type="string", nullable=true),
     *                     @OA\Property(property="tech_pass", type="string", nullable=true),
     *                     @OA\Property(property="tech_email", type="string", example="mkcsinfotech@phlebio.com"),
     *                     @OA\Property(property="tech_cell_phone", type="string", example="123654789"),
     *                     @OA\Property(property="tech_street", type="string", example="45 West 10th Street"),
     *                     @OA\Property(property="tech_city", type="string", example="Saint Paul"),
     *                     @OA\Property(property="tech_state", type="string", example="Minnesota"),
     *                     @OA\Property(property="tech_zip", type="string", example="55102"),
     *                     @OA\Property(property="tech_warning", type="string", example="Special"),
     *                     @OA\Property(property="tech_notes", type="string", example="best notes"),
     *                     @OA\Property(property="status", type="integer", example=1),
     *                     @OA\Property(property="service_hubid", type="integer", example=1),
     *                     @OA\Property(property="subscriber_id", type="integer", example=0),
     *                     @OA\Property(property="tech_profileimage", type="string", example="1620911292.png"),
     *                     @OA\Property(property="deleted_at", type="integer", example=0),
     *                     @OA\Property(property="is_supervisor", type="integer", example=0),
     *                     @OA\Property(property="hub_name", type="string", example="Demo Service Hub One"),
     *                 ),
     *             ),
     *             @OA\Property(property="deleted", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="tech_userid", type="integer", example=117),
     *                     @OA\Property(property="tech_first_name", type="string", example="Janet"),
     *                     @OA\Property(property="tech_last_name", type="string", example="Needlepro"),
     *                     @OA\Property(property="tech_middle_name", type="string", nullable=true),
     *                     @OA\Property(property="tech_name", type="string", example="Janet Needlepro"),
     *                     @OA\Property(property="tech_phlebio_id", type="integer", nullable=true),
     *                     @OA\Property(property="tech_bkg_chk", type="integer", example=1),
     *                     @OA\Property(property="tech_bkg_chk_date", type="string", example="2021-02-28 09:53:00"),
     *                     @OA\Property(property="tech_state_cert", type="integer", example=7),
     *                     @OA\Property(property="tech_cert_num", type="string", example="2007"),
     *                     @OA\Property(property="tech_cert_level", type="integer", example=1),
     *                     @OA\Property(property="tech_cert_exp", type="string", example="2021-03-28 09:53:00"),
     *                     @OA\Property(property="tech_subscriber_id", type="integer", nullable=true),
     *                     @OA\Property(property="tech_svc_area", type="string", example="45.323338,-93.14105 , 45.110515,-91.872129 , 44.623863,-92.679624 , 44.619953,-93.706846 , 44.994093,-94.278135 , 45.238304,-93.866147 ,"),
     *                     @OA\Property(property="tech_username", type="string", nullable=true),
     *                     @OA\Property(property="tech_pass", type="string", nullable=true),
     *                     @OA\Property(property="tech_email", type="string", example="mkcsinfotech@phlebio.com"),
     *                     @OA\Property(property="tech_cell_phone", type="string", example="123654789"),
     *                     @OA\Property(property="tech_street", type="string", example="45 West 10th Street"),
     *                     @OA\Property(property="tech_city", type="string", example="Saint Paul"),
     *                     @OA\Property(property="tech_state", type="string", example="Minnesota"),
     *                     @OA\Property(property="tech_zip", type="string", example="55102"),
     *                     @OA\Property(property="tech_warning", type="string", example="Special"),
     *                     @OA\Property(property="tech_notes", type="string", example="best notes"),
     *                     @OA\Property(property="status", type="integer", example=1),
     *                     @OA\Property(property="service_hubid", type="integer", example=1),
     *                     @OA\Property(property="subscriber_id", type="integer", example=0),
     *                     @OA\Property(property="tech_profileimage", type="string", example="1620911292.png"),
     *                     @OA\Property(property="deleted_at", type="integer", example=0),
     *                     @OA\Property(property="is_supervisor", type="integer", example=0),
     *                     @OA\Property(property="hub_name", type="string", example="Demo Service Hub One"),
     *                 ),
     *             ),
     *         ),
     *     ),
     * )
     */
    public function getList(Request $request){
        $currentTimeStamp = $request->timestamp ? Carbon::createFromTimestamp($request->timestamp)->format('Y-m-d') : null;
        $added = [];
        $updated = [];
        $deleted = [];
        if($currentTimeStamp){
            // whereNull('deleted_at')
            // whereNotNull('deleted_at')
            $added = Technician::leftJoin('servicehub','servicehub.servicehub_id','=','technician.service_hubid')->whereNull('technician.deleted_at')->whereDate('technician.created_at','>=',$currentTimeStamp)->get(['technician.tech_userid','technician.tech_first_name','technician.tech_last_name','technician.tech_middle_name','technician.tech_name','technician.tech_phlebio_id','technician.tech_bkg_chk','technician.tech_bkg_chk_date','technician.tech_state_cert','technician.tech_cert_num','technician.tech_cert_level','technician.tech_cert_exp','technician.tech_subscriber_id','technician.tech_svc_area','technician.tech_username','technician.tech_pass','technician.tech_email','technician.tech_cell_phone','technician.tech_street','technician.tech_city','technician.tech_state','technician.tech_zip','technician.tech_warning','technician.tech_notes','technician.status','technician.service_hubid','technician.subscriber_id','technician.tech_profileimage','technician.deleted_at','technician.is_supervisor','servicehub.hub_name']);
            $addedIDs = $added->pluck('technician.tech_userid')->toArray();
            $updated = Technician::leftJoin('servicehub','servicehub.servicehub_id','=','technician.service_hubid')->whereNotIn('technician.tech_userid',$addedIDs)->whereNull('technician.deleted_at')->whereDate('technician.updated_at','>=',$currentTimeStamp)->get(['technician.tech_userid','technician.tech_first_name','technician.tech_last_name','technician.tech_middle_name','technician.tech_name','technician.tech_phlebio_id','technician.tech_bkg_chk','technician.tech_bkg_chk_date','technician.tech_state_cert','technician.tech_cert_num','technician.tech_cert_level','technician.tech_cert_exp','technician.tech_subscriber_id','technician.tech_svc_area','technician.tech_username','technician.tech_pass','technician.tech_email','technician.tech_cell_phone','technician.tech_street','technician.tech_city','technician.tech_state','technician.tech_zip','technician.tech_warning','technician.tech_notes','technician.status','technician.service_hubid','technician.subscriber_id','technician.tech_profileimage','technician.deleted_at','technician.is_supervisor','servicehub.hub_name']);
            $deleted = Technician::leftJoin('servicehub','servicehub.servicehub_id','=','technician.service_hubid')->whereNotNull('technician.deleted_at')->whereDate('technician.updated_at','>=',$currentTimeStamp)->get(['technician.tech_userid','technician.tech_first_name','technician.tech_last_name','technician.tech_middle_name','technician.tech_name','technician.tech_phlebio_id','technician.tech_bkg_chk','technician.tech_bkg_chk_date','technician.tech_state_cert','technician.tech_cert_num','technician.tech_cert_level','technician.tech_cert_exp','technician.tech_subscriber_id','technician.tech_svc_area','technician.tech_username','technician.tech_pass','technician.tech_email','technician.tech_cell_phone','technician.tech_street','technician.tech_city','technician.tech_state','technician.tech_zip','technician.tech_warning','technician.tech_notes','technician.status','technician.service_hubid','technician.subscriber_id','technician.tech_profileimage','technician.deleted_at','technician.is_supervisor','servicehub.hub_name']);
        }else{
            $added = Technician::leftJoin('servicehub','servicehub.servicehub_id','=','technician.service_hubid')->whereNull('technician.deleted_at')->get(['technician.tech_userid','technician.tech_first_name','technician.tech_last_name','technician.tech_middle_name','technician.tech_name','technician.tech_phlebio_id','technician.tech_bkg_chk','technician.tech_bkg_chk_date','technician.tech_state_cert','technician.tech_cert_num','technician.tech_cert_level','technician.tech_cert_exp','technician.tech_subscriber_id','technician.tech_svc_area','technician.tech_username','technician.tech_pass','technician.tech_email','technician.tech_cell_phone','technician.tech_street','technician.tech_city','technician.tech_state','technician.tech_zip','technician.tech_warning','technician.tech_notes','technician.status','technician.service_hubid','technician.subscriber_id','technician.tech_profileimage','technician.deleted_at','technician.is_supervisor','servicehub.hub_name']);
            $deleted = Technician::leftJoin('servicehub','servicehub.servicehub_id','=','technician.service_hubid')->whereNotNull('technician.deleted_at')->get(['technician.tech_userid','technician.tech_first_name','technician.tech_last_name','technician.tech_middle_name','technician.tech_name','technician.tech_phlebio_id','technician.tech_bkg_chk','technician.tech_bkg_chk_date','technician.tech_state_cert','technician.tech_cert_num','technician.tech_cert_level','technician.tech_cert_exp','technician.tech_subscriber_id','technician.tech_svc_area','technician.tech_username','technician.tech_pass','technician.tech_email','technician.tech_cell_phone','technician.tech_street','technician.tech_city','technician.tech_state','technician.tech_zip','technician.tech_warning','technician.tech_notes','technician.status','technician.service_hubid','technician.subscriber_id','technician.tech_profileimage','technician.deleted_at','technician.is_supervisor','servicehub.hub_name']);
        }
        if(count($added)>0){
            $added = $added->map(function($item){
                $techSvcArea = $item->tech_svc_area;
                $latLongArray = [];
                if($techSvcArea){
                    $coordinates = explode(" , ", $techSvcArea);

                    // Iterate through each pair and convert it into an array
                    foreach ($coordinates as $coord) {
                        list($lat, $lng) = explode(",", $coord);
                        $latLongArray[] = [$lat, $lng];
                    }

                }
                $item->tech_svc_area = $latLongArray;
                return $item;
            });
        }

        if(count($updated)>0){
            $updated = $updated->map(function($item){
                $techSvcArea = $item->tech_svc_area;
                $latLongArray = [];
                if($techSvcArea){
                    $coordinates = explode(" , ", $techSvcArea);

                    // Iterate through each pair and convert it into an array
                    foreach ($coordinates as $coord) {
                        list($lat, $lng) = explode(",", $coord);
                        $latLongArray[] = [$lat, $lng];
                    }

                }
                $item->tech_svc_area = $latLongArray;
                return $item;
            });
        }

        if(count($deleted)>0){
            $deleted = $deleted->map(function($item){
                $techSvcArea = $item->tech_svc_area;
                $latLongArray = [];
                if($techSvcArea){
                    $coordinates = explode(" , ", $techSvcArea);

                    // Iterate through each pair and convert it into an array
                    foreach ($coordinates as $coord) {
                        list($lat, $lng) = explode(",", $coord);
                        $latLongArray[] = [$lat, $lng];
                    }

                }
                $item->tech_svc_area = $latLongArray;
                return $item;
            });
        }
        return ['success'=>true,"added"=>$added, "updated"=>$updated, "deleted"=>$deleted];
    }

    public function technicianNotification(Request $request)
    {
        $technicianId=$request->get('tech_id');
        $order=$request->get("order");
        $details = [];
        if($order!=null && $order!='')
        {
            $details = explode(",",$order);
        }
        $topic = "phlebio_tech_".$technicianId;

        $title = "New orders assigned";
        $message = "Hello, you have new orders assigned to you by your Dispatch Team";

        $statData= ['stat'=>false];

        $result = false;

        if(count($details)>0)
        {
            foreach($details as $detail)
            {
                $queryResult = DB::select("select client_stat from tbl_order where order_id = :id", ['id' => $detail]);

                // Initialize $stat as false
                $stat = false;

                if (!empty($queryResult)) {
                    $clientStat = $queryResult[0]->client_stat;
                    // Check if client_stat contains an underscore
                    if (strpos($clientStat, '_') !== false) {
                        $stat = true;
                        $message = "Hello, one or more STAT orders have just been assigned to you by your Dispatch Team";
                        $statData= ['stat'=>true];
                        break; // noo need to check if stat is already true.
                    }
                }
            }
            $result = PushNotificationRepository::sendPushToTopic($topic, $title,$message,$statData);
        }

        return ["success"=>$result];
    }
}
