<?php

namespace App\Http\Controllers;

use App\Models\ServiceHub;
use Carbon\Carbon;
use Illuminate\Http\Request;

class ServiceHubController extends Controller
{
    /**
     * @OA\Post(
     *     path="/api/servicehub/getlist",
     *     operationId="ServiceHubList",
     *     tags={"Protected Routes"},
     *     summary="Get List of ServiceHub",
     *     description="This route requires authentication. Retrieves a list of ServiceHub with details on added, updated, and deleted items.",
     *     security={{"bearerAuth": {}}},
     *     @OA\RequestBody(
     *         required=true,
     *         description="User credentials",
     *         @OA\JsonContent(
     *             @OA\Property(property="timestamp", type="string", format="timestamp", example=1828384884)
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Successful response",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="success", type="boolean", example=true),
     *             @OA\Property(property="added", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="hub_name", type="string", example="Demo Service Hub One"),
     *                     @OA\Property(property="hub_email", type="string", example="info@phlebio.com"),
     *                     @OA\Property(property="hub_phone", type="string", example="5552223333"),
     *                     @OA\Property(property="hub_fax", type="string", example="5551118888"),
     *                     @OA\Property(property="hub_website", type="string", example="www.phlebio.com"),
     *                     @OA\Property(property="hub_street", type="string", example="45 West 10th Street"),
     *                     @OA\Property(property="hub_city", type="string", example="Saint Paul"),
     *                     @OA\Property(property="hub_state", type="string", example="Minnesota"),
     *                     @OA\Property(property="hub_zip", type="string", example="55102"),
     *                     @OA\Property(property="hub_notes", type="string", example="Demo Service Hub"),
     *                     @OA\Property(property="status", type="integer", example=1),
     *                     @OA\Property(property="subscriber_id", type="integer", nullable=true),
     *                     @OA\Property(property="delete_by", type="integer", nullable=true),
     *                     @OA\Property(property="hub_svc_area", type="string", example="  "),
     *                     @OA\Property(property="deleted_at", type="integer", example=0),
     *                     @OA\Property(property="hub_account_no", type="string", nullable=true),
     *                     @OA\Property(property="hub_contact_name", type="string", nullable=true),
     *                     @OA\Property(property="hub_contact_phone", type="string", nullable=true),
     *                     @OA\Property(property="hub_contact_email", type="string", nullable=true),
     *                     @OA\Property(property="latitude", type="string", example="44.949063"),
     *                     @OA\Property(property="longitude", type="string", example="-93.0999889"),
     *                 ),
     *             ),
     *             @OA\Property(property="updated", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="hub_name", type="string", example="Demo Service Hub One"),
     *                     @OA\Property(property="hub_email", type="string", example="info@phlebio.com"),
     *                     @OA\Property(property="hub_phone", type="string", example="5552223333"),
     *                     @OA\Property(property="hub_fax", type="string", example="5551118888"),
     *                     @OA\Property(property="hub_website", type="string", example="www.phlebio.com"),
     *                     @OA\Property(property="hub_street", type="string", example="45 West 10th Street"),
     *                     @OA\Property(property="hub_city", type="string", example="Saint Paul"),
     *                     @OA\Property(property="hub_state", type="string", example="Minnesota"),
     *                     @OA\Property(property="hub_zip", type="string", example="55102"),
     *                     @OA\Property(property="hub_notes", type="string", example="Demo Service Hub"),
     *                     @OA\Property(property="status", type="integer", example=1),
     *                     @OA\Property(property="subscriber_id", type="integer", nullable=true),
     *                     @OA\Property(property="delete_by", type="integer", nullable=true),
     *                     @OA\Property(property="hub_svc_area", type="string", example="  "),
     *                     @OA\Property(property="deleted_at", type="integer", example=0),
     *                     @OA\Property(property="hub_account_no", type="string", nullable=true),
     *                     @OA\Property(property="hub_contact_name", type="string", nullable=true),
     *                     @OA\Property(property="hub_contact_phone", type="string", nullable=true),
     *                     @OA\Property(property="hub_contact_email", type="string", nullable=true),
     *                     @OA\Property(property="latitude", type="string", example="44.949063"),
     *                     @OA\Property(property="longitude", type="string", example="-93.0999889"),
     *                 ),
     *             ),
     *             @OA\Property(property="deleted", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="hub_name", type="string", example="Demo Service Hub One"),
     *                     @OA\Property(property="hub_email", type="string", example="info@phlebio.com"),
     *                     @OA\Property(property="hub_phone", type="string", example="5552223333"),
     *                     @OA\Property(property="hub_fax", type="string", example="5551118888"),
     *                     @OA\Property(property="hub_website", type="string", example="www.phlebio.com"),
     *                     @OA\Property(property="hub_street", type="string", example="45 West 10th Street"),
     *                     @OA\Property(property="hub_city", type="string", example="Saint Paul"),
     *                     @OA\Property(property="hub_state", type="string", example="Minnesota"),
     *                     @OA\Property(property="hub_zip", type="string", example="55102"),
     *                     @OA\Property(property="hub_notes", type="string", example="Demo Service Hub"),
     *                     @OA\Property(property="status", type="integer", example=1),
     *                     @OA\Property(property="subscriber_id", type="integer", nullable=true),
     *                     @OA\Property(property="delete_by", type="integer", nullable=true),
     *                     @OA\Property(property="hub_svc_area", type="string", example="  "),
     *                     @OA\Property(property="deleted_at", type="integer", example=0),
     *                     @OA\Property(property="hub_account_no", type="string", nullable=true),
     *                     @OA\Property(property="hub_contact_name", type="string", nullable=true),
     *                     @OA\Property(property="hub_contact_phone", type="string", nullable=true),
     *                     @OA\Property(property="hub_contact_email", type="string", nullable=true),
     *                     @OA\Property(property="latitude", type="string", example="44.949063"),
     *                     @OA\Property(property="longitude", type="string", example="-93.0999889"),
     *                 ),
     *             ),
     *         ),
     *     ),
     * )
     */
    public function getList(Request $request){
        $currentTimeStamp = $request->timestamp ? Carbon::createFromTimestamp($request->timestamp)->format('Y-m-d') : null;
        $added = [];
        $updated = [];
        $deleted = [];
        if($currentTimeStamp){
            // whereNull('deleted_at')
            // whereNotNull('deleted_at')
            $added = ServiceHub::whereNull('deleted_at')->whereDate('created_at','>=',$currentTimeStamp)->get(["servicehub_id",'hub_name','hub_email','hub_phone','hub_fax','hub_website','hub_street','hub_city','hub_state','hub_zip','hub_notes','status','subscriber_id','delete_by','hub_svc_area','deleted_at','hub_account_no','hub_contact_name','hub_contact_phone','hub_contact_email','latitude','longitude']);
            $addedIDs = $added->pluck('servicehub_id')->toArray();
            $updated = ServiceHub::whereNotIn('servicehub_id',$addedIDs)->whereNull('deleted_at')->whereDate('updated_at','>=',$currentTimeStamp)->get(["servicehub_id",'hub_name','hub_email','hub_phone','hub_fax','hub_website','hub_street','hub_city','hub_state','hub_zip','hub_notes','status','subscriber_id','delete_by','hub_svc_area','deleted_at','hub_account_no','hub_contact_name','hub_contact_phone','hub_contact_email','latitude','longitude']);
            $deleted = ServiceHub::whereNotNull('deleted_at')->whereDate('updated_at','>=',$currentTimeStamp)->get(["servicehub_id",'hub_name','hub_email','hub_phone','hub_fax','hub_website','hub_street','hub_city','hub_state','hub_zip','hub_notes','status','subscriber_id','delete_by','hub_svc_area','deleted_at','hub_account_no','hub_contact_name','hub_contact_phone','hub_contact_email','latitude','longitude']);
        }else{
            $added = ServiceHub::whereNull('deleted_at')->get(["servicehub_id",'hub_name','hub_email','hub_phone','hub_fax','hub_website','hub_street','hub_city','hub_state','hub_zip','hub_notes','status','subscriber_id','delete_by','hub_svc_area','deleted_at','hub_account_no','hub_contact_name','hub_contact_phone','hub_contact_email','latitude','longitude']);
            $deleted = ServiceHub::whereNotNull('deleted_at')->get(["servicehub_id",'hub_name','hub_email','hub_phone','hub_fax','hub_website','hub_street','hub_city','hub_state','hub_zip','hub_notes','status','subscriber_id','delete_by','hub_svc_area','deleted_at','hub_account_no','hub_contact_name','hub_contact_phone','hub_contact_email','latitude','longitude']);
        }
        return ['success'=>true,"added"=>$added, "updated"=>$updated, "deleted"=>$deleted];
    }
}
