<?php

namespace App\Http\Controllers;

use App\Models\RejectReason;
use Carbon\Carbon;
use Illuminate\Http\Request;

class RejectReasonController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:api');
    }
    /**
     * @OA\Post(
     *     path="/api/rejectreason/getlist",
     *     operationId="rejectreasonList",
     *     tags={"Protected Routes"},
     *     summary="Get List of RejectReason",
     *     description="This route requires authentication. Retrieves a list of RejectReason with details on added, updated, and deleted items.",
     *     security={{"bearerAuth": {}}},
     *     @OA\RequestBody(
     *         required=true,
     *         description="User credentials",
     *         @OA\JsonContent(
     *             @OA\Property(property="timestamp", type="string", format="timestamp", example=1828384884)
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Successful response",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="success", type="boolean", example=true),
     *             @OA\Property(property="added", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="reason_code", type="integer", example=1),
     *                     @OA\Property(property="reason", type="string", example="Tube validation failure"),
     *                     @OA\Property(property="client_reason", type="integer", example=0),
     *                     @OA\Property(property="hide_in_app", type="integer", example=1),
     *
     *                     @OA\Property(property="Failedpickup_reason", type="integer", example=0),
     *                     @OA\Property(property="group_id", type="integer", example=1),
     *                     @OA\Property(property="include_in_statboard", type="integer", example=0),
     *                     @OA\Property(property="mk2processdashboard_reason", type="integer", example=0),
     *                     @OA\Property(property="delete_status", type="integer", example=0),
     *                 ),
     *             ),
     *             @OA\Property(property="updated", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="reason_code", type="integer", example=1),
     *                     @OA\Property(property="reason", type="string", example="Tube validation failure"),
     *                     @OA\Property(property="client_reason", type="integer", example=0),
     *                     @OA\Property(property="hide_in_app", type="integer", example=1),
     *
     *                     @OA\Property(property="Failedpickup_reason", type="integer", example=0),
     *                     @OA\Property(property="group_id", type="integer", example=1),
     *                     @OA\Property(property="include_in_statboard", type="integer", example=0),
     *                     @OA\Property(property="mk2processdashboard_reason", type="integer", example=0),
     *                     @OA\Property(property="delete_status", type="integer", example=0),
     *                 ),
     *             ),
     *             @OA\Property(property="deleted", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="reason_code", type="integer", example=1),
     *                     @OA\Property(property="reason", type="string", example="Tube validation failure"),
     *                     @OA\Property(property="client_reason", type="integer", example=0),
     *                     @OA\Property(property="hide_in_app", type="integer", example=1),
     *
     *                     @OA\Property(property="Failedpickup_reason", type="integer", example=0),
     *                     @OA\Property(property="group_id", type="integer", example=1),
     *                     @OA\Property(property="include_in_statboard", type="integer", example=0),
     *                     @OA\Property(property="mk2processdashboard_reason", type="integer", example=0),
     *                     @OA\Property(property="delete_status", type="integer", example=0),
     *                 ),
     *             ),
     *         ),
     *     ),
     * )
     */
    public function getList(Request $request){
        $timestamp = $request->timestamp;
        if(strlen($timestamp)==13)
        {
            $timestamp = intval($timestamp/1000);
        }
        $currentTimeStamp = $request->timestamp ? Carbon::createFromTimestamp($timestamp)->format('Y-m-d') : null;
        
        $added = [];
        $updated = [];
        $deleted = [];
        if($currentTimeStamp){
            // client_reason not found
            // hide_in_app not found
            // Failedpickup_reason not found
            // group_id not found
            // include_in_statboard not found
            // mk2processdashboard_reason not found
            // whereNull('deleted_at')
            // whereNotNull('deleted_at')
            $added = RejectReason::whereNull('deleted_at')->whereDate('created_at','>=',$currentTimeStamp)->get(['id','reason_code','reason','delete_status']);
            $addedIDs = $added->pluck('id')->toArray();
            $updated = RejectReason::whereNotIn('id',$addedIDs)->whereNull('deleted_at')->whereDate('updated_at','>=',$currentTimeStamp)->get(['id','reason_code','reason','delete_status']);
            $deleted = RejectReason::whereNotNull('deleted_at')->whereDate('updated_at','>=',$currentTimeStamp)->get(['id','reason_code','reason','delete_status']);
        }else{
            $added = RejectReason::whereNull('deleted_at')->get(['id','reason_code','reason','delete_status']);
            $deleted = RejectReason::whereNotNull('deleted_at')->get(['id','reason_code','reason','delete_status']);
        }
        return ['success'=>true,"added"=>$added, "updated"=>$updated, "deleted"=>$deleted];
    }
}
