<?php

namespace App\Http\Controllers;

use App\Models\Patient;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class PatientController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:api');
    }
    /**
     * @OA\Post(
     *     path="/api/patient/getlist",
     *     operationId="patientList",
     *     tags={"Protected Routes"},
     *     summary="Get List of patient",
     *     description="This route requires authentication. Retrieves a list of patient with details on added, updated, and deleted items.",
     *     security={{"bearerAuth": {}}},
     *     @OA\RequestBody(
     *         required=true,
     *         description="User credentials",
     *         @OA\JsonContent(
     *             @OA\Property(property="timestamp", type="string", format="timestamp", example=1828384884)
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Successful response",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="success", type="boolean", example=true),
     *             @OA\Property(property="added", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                      @OA\Property(property="patient_name", type="string", example="VISIT THIS FACILITY"),
     *                      @OA\Property(property="patient_first_name", type="string", example="VISIT"),
     *                      @OA\Property(property="patient_middle_name", type="string", example="THIS"),
     *                      @OA\Property(property="patient_last_name", type="string", example="FACILITY"),
     *                      @OA\Property(property="patient_email", type="string", example="rodney@phlebio.com"),
     *                      @OA\Property(property="patient_phone", type="string", example="626-945-2007"),
     *                      @OA\Property(property="patient_phone2", type="string", example=""),
     *                      @OA\Property(property="patient_phone3", type="string", example=""),
     *                      @OA\Property(property="patient_servicehub", type="string", example="3"),
     *                      @OA\Property(property="patient_website", type="string", nullable=true),
     *                      @OA\Property(property="patient_dob", type="string", format="date", example="1999-03-17"),
     *                      @OA\Property(property="patient_gender", type="integer", example=1),
     *                      @OA\Property(property="patient_ssn", type="string", example="SSN123456"),
     *                      @OA\Property(property="patient_street", type="string", example="604 NE First St."),
     *                      @OA\Property(property="patient_city", type="string", example="Forest Lake"),
     *                      @OA\Property(property="patient_state", type="string", example="Minnesota"),
     *                      @OA\Property(property="patient_zip", type="string", example="55025"),
     *                      @OA\Property(property="patient_insurance_primary", type="integer", example=0),
     *                      @OA\Property(property="patient_insurance_primary_id", type="string", example=""),
     *                      @OA\Property(property="patient_insurance_secondary", type="integer", example=0),
     *                      @OA\Property(property="patient_insurance_secondary_id", type="string", example=""),
     *                      @OA\Property(property="patient_billing_responsibility", type="integer", example=0),
     *                      @OA\Property(property="patient_residence", type="integer", example=0),
     *                      @OA\Property(property="patient_facility", type="integer", example=0),
     *                      @OA\Property(property="private_address", type="string", example=""),
     *                      @OA\Property(property="provider_id", type="string", example="1"),
     *                      @OA\Property(property="client_id", type="string", example="1"),
     *                      @OA\Property(property="status", type="integer", example=1),
     *                      @OA\Property(property="subscriber_id", type="integer", nullable=true),
     *                      @OA\Property(property="patient_notes", type="string", nullable=true),
     *                      @OA\Property(property="delete_by", type="integer", nullable=true),
     *                      @OA\Property(property="deleted_at", type="integer", example=0),
     *                      @OA\Property(property="code_id", type="string", example=""),
     *                      @OA\Property(property="latitude", type="string", example="43.083822"),
     *                      @OA\Property(property="longitude", type="string", example="-70.810761"),
     *                      @OA\Property(property="sms_notification", type="integer", example=0),
     *                      @OA\Property(property="email_notification", type="integer", example=0),
     *                      @OA\Property(property="sms_notification_status", type="string", nullable=true),
     *                      @OA\Property(property="email_notification_status", type="string", example=""),
     *                      @OA\Property(property="patient_expired", type="integer", example=0),
     *                      @OA\Property(property="room_no", type="string", nullable=true),
     *                      @OA\Property(property="patient_pid", type="string", nullable=true),
     *                      @OA\Property(property="primary_insurance_group_no", type="string", nullable=true),
     *                      @OA\Property(property="secondary_insurance_group_no", type="string", nullable=true),
     *                      @OA\Property(property="relationship_insured", type="integer", example=0),
     *                      @OA\Property(property="insured_name", type="string", nullable=true),
     *                      @OA\Property(property="patient_standing_order_no", type="string", nullable=true),
     *                 ),
     *             ),
     *             @OA\Property(property="updated", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                      @OA\Property(property="patient_name", type="string", example="VISIT THIS FACILITY"),
     *                      @OA\Property(property="patient_first_name", type="string", example="VISIT"),
     *                      @OA\Property(property="patient_middle_name", type="string", example="THIS"),
     *                      @OA\Property(property="patient_last_name", type="string", example="FACILITY"),
     *                      @OA\Property(property="patient_email", type="string", example="rodney@phlebio.com"),
     *                      @OA\Property(property="patient_phone", type="string", example="626-945-2007"),
     *                      @OA\Property(property="patient_phone2", type="string", example=""),
     *                      @OA\Property(property="patient_phone3", type="string", example=""),
     *                      @OA\Property(property="patient_servicehub", type="string", example="3"),
     *                      @OA\Property(property="patient_website", type="string", nullable=true),
     *                      @OA\Property(property="patient_dob", type="string", format="date", example="1999-03-17"),
     *                      @OA\Property(property="patient_gender", type="integer", example=1),
     *                      @OA\Property(property="patient_ssn", type="string", example="SSN123456"),
     *                      @OA\Property(property="patient_street", type="string", example="604 NE First St."),
     *                      @OA\Property(property="patient_city", type="string", example="Forest Lake"),
     *                      @OA\Property(property="patient_state", type="string", example="Minnesota"),
     *                      @OA\Property(property="patient_zip", type="string", example="55025"),
     *                      @OA\Property(property="patient_insurance_primary", type="integer", example=0),
     *                      @OA\Property(property="patient_insurance_primary_id", type="string", example=""),
     *                      @OA\Property(property="patient_insurance_secondary", type="integer", example=0),
     *                      @OA\Property(property="patient_insurance_secondary_id", type="string", example=""),
     *                      @OA\Property(property="patient_billing_responsibility", type="integer", example=0),
     *                      @OA\Property(property="patient_residence", type="integer", example=0),
     *                      @OA\Property(property="patient_facility", type="integer", example=0),
     *                      @OA\Property(property="private_address", type="string", example=""),
     *                      @OA\Property(property="provider_id", type="string", example="1"),
     *                      @OA\Property(property="client_id", type="string", example="1"),
     *                      @OA\Property(property="status", type="integer", example=1),
     *                      @OA\Property(property="subscriber_id", type="integer", nullable=true),
     *                      @OA\Property(property="patient_notes", type="string", nullable=true),
     *                      @OA\Property(property="delete_by", type="integer", nullable=true),
     *                      @OA\Property(property="deleted_at", type="integer", example=0),
     *                      @OA\Property(property="code_id", type="string", example=""),
     *                      @OA\Property(property="latitude", type="string", example="43.083822"),
     *                      @OA\Property(property="longitude", type="string", example="-70.810761"),
     *                      @OA\Property(property="sms_notification", type="integer", example=0),
     *                      @OA\Property(property="email_notification", type="integer", example=0),
     *                      @OA\Property(property="sms_notification_status", type="string", nullable=true),
     *                      @OA\Property(property="email_notification_status", type="string", example=""),
     *                      @OA\Property(property="patient_expired", type="integer", example=0),
     *                      @OA\Property(property="room_no", type="string", nullable=true),
     *                      @OA\Property(property="patient_pid", type="string", nullable=true),
     *                      @OA\Property(property="primary_insurance_group_no", type="string", nullable=true),
     *                      @OA\Property(property="secondary_insurance_group_no", type="string", nullable=true),
     *                      @OA\Property(property="relationship_insured", type="integer", example=0),
     *                      @OA\Property(property="insured_name", type="string", nullable=true),
     *                      @OA\Property(property="patient_standing_order_no", type="string", nullable=true),
     *                 ),
     *             ),
     *             @OA\Property(property="deleted", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                      @OA\Property(property="patient_name", type="string", example="VISIT THIS FACILITY"),
     *                      @OA\Property(property="patient_first_name", type="string", example="VISIT"),
     *                      @OA\Property(property="patient_middle_name", type="string", example="THIS"),
     *                      @OA\Property(property="patient_last_name", type="string", example="FACILITY"),
     *                      @OA\Property(property="patient_email", type="string", example="rodney@phlebio.com"),
     *                      @OA\Property(property="patient_phone", type="string", example="626-945-2007"),
     *                      @OA\Property(property="patient_phone2", type="string", example=""),
     *                      @OA\Property(property="patient_phone3", type="string", example=""),
     *                      @OA\Property(property="patient_servicehub", type="string", example="3"),
     *                      @OA\Property(property="patient_website", type="string", nullable=true),
     *                      @OA\Property(property="patient_dob", type="string", format="date", example="1999-03-17"),
     *                      @OA\Property(property="patient_gender", type="integer", example=1),
     *                      @OA\Property(property="patient_ssn", type="string", example="SSN123456"),
     *                      @OA\Property(property="patient_street", type="string", example="604 NE First St."),
     *                      @OA\Property(property="patient_city", type="string", example="Forest Lake"),
     *                      @OA\Property(property="patient_state", type="string", example="Minnesota"),
     *                      @OA\Property(property="patient_zip", type="string", example="55025"),
     *                      @OA\Property(property="patient_insurance_primary", type="integer", example=0),
     *                      @OA\Property(property="patient_insurance_primary_id", type="string", example=""),
     *                      @OA\Property(property="patient_insurance_secondary", type="integer", example=0),
     *                      @OA\Property(property="patient_insurance_secondary_id", type="string", example=""),
     *                      @OA\Property(property="patient_billing_responsibility", type="integer", example=0),
     *                      @OA\Property(property="patient_residence", type="integer", example=0),
     *                      @OA\Property(property="patient_facility", type="integer", example=0),
     *                      @OA\Property(property="private_address", type="string", example=""),
     *                      @OA\Property(property="provider_id", type="string", example="1"),
     *                      @OA\Property(property="client_id", type="string", example="1"),
     *                      @OA\Property(property="status", type="integer", example=1),
     *                      @OA\Property(property="subscriber_id", type="integer", nullable=true),
     *                      @OA\Property(property="patient_notes", type="string", nullable=true),
     *                      @OA\Property(property="delete_by", type="integer", nullable=true),
     *                      @OA\Property(property="deleted_at", type="integer", example=0),
     *                      @OA\Property(property="code_id", type="string", example=""),
     *                      @OA\Property(property="latitude", type="string", example="43.083822"),
     *                      @OA\Property(property="longitude", type="string", example="-70.810761"),
     *                      @OA\Property(property="sms_notification", type="integer", example=0),
     *                      @OA\Property(property="email_notification", type="integer", example=0),
     *                      @OA\Property(property="sms_notification_status", type="string", nullable=true),
     *                      @OA\Property(property="email_notification_status", type="string", example=""),
     *                      @OA\Property(property="patient_expired", type="integer", example=0),
     *                      @OA\Property(property="room_no", type="string", nullable=true),
     *                      @OA\Property(property="patient_pid", type="string", nullable=true),
     *                      @OA\Property(property="primary_insurance_group_no", type="string", nullable=true),
     *                      @OA\Property(property="secondary_insurance_group_no", type="string", nullable=true),
     *                      @OA\Property(property="relationship_insured", type="integer", example=0),
     *                      @OA\Property(property="insured_name", type="string", nullable=true),
     *                      @OA\Property(property="patient_standing_order_no", type="string", nullable=true),
     *                 ),
     *             ),
     *         ),
     *     ),
     * )
     */
    public function getList(Request $request){
        $currentTimeStamp = $request->timestamp ? Carbon::createFromTimestamp($request->timestamp)->format('Y-m-d') : null;
        $added = [];
        $updated = [];
        $deleted = [];

            // whereNull('deleted_at')
            // whereNotNull('deleted_at')
            //room_no
            //patient_pid
            //patient_standing_order_no
        if($currentTimeStamp){
            $added = Patient::whereNull('deleted_at')->whereDate('created_at','>=',$currentTimeStamp)
                ->whereColumn('updated_at', '=', 'created_at')
                ->get(['patient_id',
                'patient_name','patient_first_name','patient_middle_name','patient_last_name',
                'patient_phone','patient_phone2','patient_phone3',
                DB::raw("DATE_FORMAT(patient_dob, '%m/%d/%Y') as patient_dob"),'patient_gender',
                'patient_insurance_primary',
                'patient_insurance_primary_id','patient_insurance_secondary','patient_insurance_secondary_id',
                'patient_notes','client_id','insured_name']);
           // $addedIDs = $added->pluck('patient_id')->toArray();
            $updated = Patient::whereNull('deleted_at')
                ->whereColumn('updated_at', '!=', 'created_at')
                ->whereDate('updated_at','>=',$currentTimeStamp)
                ->get(['patient_id',
                    'patient_name','patient_first_name','patient_middle_name','patient_last_name',
                    'patient_phone','patient_phone2','patient_phone3',
                    DB::raw("DATE_FORMAT(patient_dob, '%m/%d/%Y') as patient_dob"),'patient_gender',
                    'patient_insurance_primary',
                    'patient_insurance_primary_id','patient_insurance_secondary','patient_insurance_secondary_id',
                    'patient_notes','client_id','insured_name']);
            $deleted = Patient::whereNotNull('deleted_at')->whereDate('updated_at','>=',$currentTimeStamp)
                ->get(['patient_id',
                    'patient_name','patient_first_name','patient_middle_name','patient_last_name',
                    'patient_phone','patient_phone2','patient_phone3',
                    DB::raw("DATE_FORMAT(patient_dob, '%m/%d/%Y') as patient_dob"),'patient_gender',
                    'patient_insurance_primary',
                    'patient_insurance_primary_id','patient_insurance_secondary','patient_insurance_secondary_id',
                    'patient_notes','client_id','insured_name']);
        }else{
            $added = Patient::whereNull('deleted_at')->get(['patient_id',
                'patient_name','patient_first_name','patient_middle_name','patient_last_name',
                'patient_phone','patient_phone2','patient_phone3',
                DB::raw("DATE_FORMAT(patient_dob, '%m/%d/%Y') as patient_dob"),'patient_gender',
                'patient_insurance_primary',
                'patient_insurance_primary_id','patient_insurance_secondary','patient_insurance_secondary_id',
                'patient_notes','client_id','insured_name']);
            $deleted = Patient::whereNotNull('deleted_at')->get(['patient_id',
                'patient_name','patient_first_name','patient_middle_name','patient_last_name',
                'patient_phone','patient_phone2','patient_phone3',
                DB::raw("DATE_FORMAT(patient_dob, '%m/%d/%Y') as patient_dob"),'patient_gender',
                'patient_insurance_primary',
                'patient_insurance_primary_id','patient_insurance_secondary','patient_insurance_secondary_id',
                'patient_notes','client_id','insured_name']);
        }
        return ['success'=>true,"added"=>$added, "updated"=>$updated, "deleted"=>$deleted];
    }
}
