<?php

namespace App\Http\Controllers;

use App\Models\Laboratory;
use Carbon\Carbon;
use Illuminate\Http\Request;

class LaboratoryController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:api');
    }
    /**
     * @OA\Post(
     *     path="/api/laboratory/getlist",
     *     operationId="laboratoryList",
     *     tags={"Protected Routes"},
     *     summary="Get List of laboratory",
     *     description="This route requires authentication. Retrieves a list of laboratory with details on added, updated, and deleted items.",
     *     security={{"bearerAuth": {}}},
     *     @OA\RequestBody(
     *         required=true,
     *         description="User credentials",
     *         @OA\JsonContent(
     *             @OA\Property(property="timestamp", type="string", format="timestamp", example=1828384884)
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Successful response",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="success", type="boolean", example=true),
     *             @OA\Property(property="added", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="lab_name", type="string", example="LIFESCAN"),
     *                     @OA\Property(property="lab_email", type="string", nullable=true),
     *                     @OA\Property(property="lab_phone", type="string", example="8476638300"),
     *                     @OA\Property(property="lab_fax", type="string", example=""),
     *                     @OA\Property(property="lab_website", type="string", example="https://lifescanlab.com"),
     *                     @OA\Property(property="lab_street", type="string", example="5255 GOLF ROAD"),
     *                     @OA\Property(property="lab_city", type="string", example="Skokie"),
     *                     @OA\Property(property="lab_state", type="string", example="Illinois"),
     *                     @OA\Property(property="lab_zip", type="string", example="60077"),
     *                     @OA\Property(property="lab_is_global_default", type="integer", example=0),
     *                     @OA\Property(property="lab_is_POC", type="integer", example=0),
     *                     @OA\Property(property="laboratory_default", type="integer", example=1),
     *                     @OA\Property(property="reference_lab", type="integer", example=1),
     *                     @OA\Property(property="reference_lab_code", type="string", nullable=true),
     *                     @OA\Property(property="status", type="integer", example=1),
     *                     @OA\Property(property="subscriber_id", type="integer", nullable=true),
     *                     @OA\Property(property="delete_by", type="integer", nullable=true),
     *                     @OA\Property(property="deleted_at", type="integer", example=0),
     *                 ),
     *             ),
     *             @OA\Property(property="updated", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="lab_name", type="string", example="LIFESCAN"),
     *                     @OA\Property(property="lab_email", type="string", nullable=true),
     *                     @OA\Property(property="lab_phone", type="string", example="8476638300"),
     *                     @OA\Property(property="lab_fax", type="string", example=""),
     *                     @OA\Property(property="lab_website", type="string", example="https://lifescanlab.com"),
     *                     @OA\Property(property="lab_street", type="string", example="5255 GOLF ROAD"),
     *                     @OA\Property(property="lab_city", type="string", example="Skokie"),
     *                     @OA\Property(property="lab_state", type="string", example="Illinois"),
     *                     @OA\Property(property="lab_zip", type="string", example="60077"),
     *                     @OA\Property(property="lab_is_global_default", type="integer", example=0),
     *                     @OA\Property(property="lab_is_POC", type="integer", example=0),
     *                     @OA\Property(property="laboratory_default", type="integer", example=1),
     *                     @OA\Property(property="reference_lab", type="integer", example=1),
     *                     @OA\Property(property="reference_lab_code", type="string", nullable=true),
     *                     @OA\Property(property="status", type="integer", example=1),
     *                     @OA\Property(property="subscriber_id", type="integer", nullable=true),
     *                     @OA\Property(property="delete_by", type="integer", nullable=true),
     *                     @OA\Property(property="deleted_at", type="integer", example=0),
     *                 ),
     *             ),
     *             @OA\Property(property="deleted", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="lab_name", type="string", example="LIFESCAN"),
     *                     @OA\Property(property="lab_email", type="string", nullable=true),
     *                     @OA\Property(property="lab_phone", type="string", example="8476638300"),
     *                     @OA\Property(property="lab_fax", type="string", example=""),
     *                     @OA\Property(property="lab_website", type="string", example="https://lifescanlab.com"),
     *                     @OA\Property(property="lab_street", type="string", example="5255 GOLF ROAD"),
     *                     @OA\Property(property="lab_city", type="string", example="Skokie"),
     *                     @OA\Property(property="lab_state", type="string", example="Illinois"),
     *                     @OA\Property(property="lab_zip", type="string", example="60077"),
     *                     @OA\Property(property="lab_is_global_default", type="integer", example=0),
     *                     @OA\Property(property="lab_is_POC", type="integer", example=0),
     *                     @OA\Property(property="laboratory_default", type="integer", example=1),
     *                     @OA\Property(property="reference_lab", type="integer", example=1),
     *                     @OA\Property(property="reference_lab_code", type="string", nullable=true),
     *                     @OA\Property(property="status", type="integer", example=1),
     *                     @OA\Property(property="subscriber_id", type="integer", nullable=true),
     *                     @OA\Property(property="delete_by", type="integer", nullable=true),
     *                     @OA\Property(property="deleted_at", type="integer", example=0),
     *                 ),
     *             ),
     *         ),
     *     ),
     * )
     */
    public function getList(Request $request){
        $currentTimeStamp = $request->timestamp ? Carbon::createFromTimestamp($request->timestamp)->format('Y-m-d') : null;
        $added = [];
        $updated = [];
        $deleted = [];
        if($currentTimeStamp){
            // reference_lab not found
            // reference_lab_code not found
            $added = Laboratory::whereNull('deleted_at')->where('hide_from_tech', 0)->whereDate('created_at','>=',$currentTimeStamp)->get(["laboratory_id",'lab_name','lab_email','lab_phone','lab_fax','lab_website','lab_street','lab_city','lab_state','lab_zip','lab_is_global_default','lab_is_POC','laboratory_default','status','subscriber_id','delete_by','deleted_at']);
            $addedIDs = $added->pluck('laboratory_id')->toArray();
            $updated = Laboratory::whereNotIn('id',$addedIDs)->where('hide_from_tech', 0)->whereNull('deleted_at')->whereDate('updated_at','>=',$currentTimeStamp)->get(["laboratory_id",'lab_name','lab_email','lab_phone','lab_fax','lab_website','lab_street','lab_city','lab_state','lab_zip','lab_is_global_default','lab_is_POC','laboratory_default','status','subscriber_id','delete_by','deleted_at']);
            $deleted = Laboratory::whereNotNull('deleted_at')->orWhere('hide_from_tech', 1)->whereDate('updated_at','>=',$currentTimeStamp)->get(["laboratory_id",'lab_name','lab_email','lab_phone','lab_fax','lab_website','lab_street','lab_city','lab_state','lab_zip','lab_is_global_default','lab_is_POC','laboratory_default','status','subscriber_id','delete_by','deleted_at']);
        }else{
            $added = Laboratory::whereNull('deleted_at')->where('hide_from_tech', 0)->get(["laboratory_id",'lab_name','lab_email','lab_phone','lab_fax','lab_website','lab_street','lab_city','lab_state','lab_zip','lab_is_global_default','lab_is_POC','laboratory_default','status','subscriber_id','delete_by','deleted_at']);
            $deleted = Laboratory::whereNotNull('deleted_at')->orWhere('hide_from_tech', 1)->get(["laboratory_id",'lab_name','lab_email','lab_phone','lab_fax','lab_website','lab_street','lab_city','lab_state','lab_zip','lab_is_global_default','lab_is_POC','laboratory_default','status','subscriber_id','delete_by','deleted_at']);
        }
        return ['success'=>true,"added"=>$added, "updated"=>$updated, "deleted"=>$deleted];
    }
}
