<?php

namespace App\Http\Controllers;

use App\Models\DataQueue;
use App\Traits\CurlData;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Tymon\JWTAuth\Facades\JWTAuth;

class ExternalApiController extends Controller
{
    private $apiUrl;
    // curlData traits call
    use CurlData;

    public function __construct()
    {
        $this->middleware('auth:api');
        $this->apiUrl = env('MAIN_APP_RUNNING',true) ? env('MAIN_APP_LIVE_API_URL','https://sys.edevlabwerks.com/api/') : env('MAIN_APP_SANDBOX_API_URL','https://poc.edevlabwerks.com/api/');
        // $this->apiUrl = 'https://poc.edevlabwerks.com/api/';
        // move to env later
    }
    /**
     * @OA\Post(
     *     path="/api/startshift",
     *     operationId="startShift",
     *     tags={"Protected Routes"},
     *     summary="Get List of startShift",
     *     description="This route requires authentication. Retrieves a list of startShift with details on added, updated, and deleted items.",
     *     security={{"bearerAuth": {}}},
     *     @OA\RequestBody(
     *         required=true,
     *         description="User credentials",
     *         @OA\JsonContent(
     *             @OA\Property(property="statusnotes", type="string"),
     *             @OA\Property(property="latitude", type="string"),
     *             @OA\Property(property="longitude", type="string")
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Successful response",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="success", type="boolean", example=true),
     *             @OA\Property(property="error", type="string"),
     *             @OA\Property(property="data", type="array",
     *                  @OA\Items(type="object",
     *                      @OA\Property(property="status", type="string"),
     *                      @OA\Property(property="message", type="string"),
     *                  )
     *             ),
     *         ),
     *     ),
     * )
     */


    public function startShift(Request $request){

        $user_id = JWTAuth::user()->user_id;
        $jsonData = [
            'tech_id'=>$user_id,
            'statusnotes'=>$request->statusnotes,
            'latitude'=>$request->latitude,
            'longitude'=>$request->longitude,
        ];
        // Convert array to JSON
        $jsonString = json_encode($jsonData);

        // API endpoint URL
        $apiUrl = $this->apiUrl.'dashboardacceptedallroute';

        // cURL initialization
        $ch = curl_init($apiUrl);

        // Set cURL options
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonString);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Content-Length: ' . strlen($jsonString),
        ]);

        // Execute cURL session and get the response
        $response = curl_exec($ch);

        // Check for cURL errors
        if (curl_errno($ch)) {
            // Handle error
            return response()->json(['success'=>false,'error'=>curl_error($ch)]);
        }

        // Close cURL session
        curl_close($ch);

        return response()->json(['success'=>true,'error'=>'','data'=>json_decode($response, true)]);
    }

    /**
     * @OA\Post(
     *     path="/api/endshift",
     *     operationId="endShift",
     *     tags={"Protected Routes"},
     *     summary="Get List of endShift",
     *     description="This route requires authentication. Retrieves a list of endShift with details on added, updated, and deleted items.",
     *     security={{"bearerAuth": {}}},
     *     @OA\RequestBody(
     *         required=true,
     *         description="User credentials",
     *         @OA\JsonContent(
     *             @OA\Property(property="statusnotes", type="string"),
     *             @OA\Property(property="latitude", type="string"),
     *             @OA\Property(property="longitude", type="string"),
     *             @OA\Property(property="reject_reason", type="string")
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Successful response",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="success", type="boolean", example=true),
     *             @OA\Property(property="error", type="string"),
     *             @OA\Property(property="data", type="array",
     *                  @OA\Items(type="object",
     *                      @OA\Property(property="status", type="string"),
     *                      @OA\Property(property="message", type="string"),
     *                  )
     *             ),
     *         ),
     *     ),
     * )
     */
    public function endShift(Request $request){
        $user_id = JWTAuth::user()->user_id;
        $jsonData = [
            'tech_id'=>$user_id,
            'statusnotes'=>$request->statusnotes,
            'latitude'=>$request->latitude,
            'longitude'=>$request->longitude,
            'reject_reason'=>$request->reject_reason
        ];
        // Convert array to JSON
        $jsonString = json_encode($jsonData);

        // API endpoint URL
        $apiUrl = $this->apiUrl.'Endshift';

        // cURL initialization
        $ch = curl_init($apiUrl);

        // Set cURL options
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonString);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Content-Length: ' . strlen($jsonString),
        ]);

        // Execute cURL session and get the response
        $response = curl_exec($ch);

        // Check for cURL errors
        if (curl_errno($ch)) {
            // Handle error
            return response()->json(['success'=>false,'error'=>curl_error($ch)]);
        }

        // Close cURL session
        curl_close($ch);


        return response()->json(['success'=>true,'error'=>'','data'=>json_decode($response, true)]);
    }

    /**
     * @OA\Post(
     *     path="/api/app-dashboard",
     *     operationId="dashboard",
     *     tags={"Protected Routes"},
     *     summary="Get List of dashboard",
     *     description="This route requires authentication. Retrieves a list of dashboard with details on added, updated, and deleted items.",
     *     security={{"bearerAuth": {}}},
     *     @OA\RequestBody(
     *         required=true,
     *         description="User credentials",
     *         @OA\JsonContent(
     *             @OA\Property(property="timestamp", type="string", format="timestamp", example=1828384884)
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Successful response",
     *         @OA\JsonContent(
     *             type="object",
     *                 @OA\Property(property="success", type="boolean", example=true),
     *                 @OA\Property(property="error", type="string", example=""),
     *                 @OA\Property(property="data", type="object",
     *                     @OA\Property(property="status", type="string", example="OK"),
     *                     @OA\Property(property="message", type="string", example="PERFECT"),
     *                     @OA\Property(property="todaydate", type="string", example="12-13-2023 05:52:am"),
     *                     @OA\Property(property="validorderfunctionalities", type="boolean", example=true),
     *                     @OA\Property(property="totalvalidorders", type="integer", example=1),
     *                     @OA\Property(property="checkoutorder", type="integer", example=0),
     *                     @OA\Property(property="checkout_endofshift", type="integer", example=0),
     *                     @OA\Property(property="checkout_endofshiftmessage", type="string", example=""),
     *                     @OA\Property(property="reject_notes_required_always", type="integer", example=0),
     *                     @OA\Property(property="tech_background_location_status", type="integer", example=1),
     *                     @OA\Property(property="unreadmessages", type="integer", example=5),
     *                     @OA\Property(property="techician_type", type="array",
     *                         @OA\Items(type="string", example="1")
     *                     ),
     *                     @OA\Property(property="total_clients", type="integer", example=1),
     *                     @OA\Property(property="total_stops", type="integer", example=1),
     *                     @OA\Property(property="total_patients", type="integer", example=1),
     *                     @OA\Property(property="total_newphotoneededorder", type="integer", example=0),
     *                     @OA\Property(property="total_orders", type="integer", example=1),
     *                     @OA\Property(property="Client_Details", type="array",
     *                         @OA\Items(type="object",
     *                             @OA\Property(property="client_id", type="string", example="288"),
     *                             @OA\Property(property="client_name", type="string", example="WEST SUBURBAN (100-300)[WSRC1]"),
     *                             @OA\Property(property="client_phone", type="string", example="1-630-894-7400"),
     *                             @OA\Property(property="client_type_status", type="string", example="0"),
     *                             @OA\Property(property="client_type", type="string", example="NONE"),
     *                             @OA\Property(property="clientID", type="string", example="WSRC1"),
     *                             @OA\Property(property="route_lock", type="integer", example=1),
     *                             @OA\Property(property="event_no", type="string", example=null),
     *                             @OA\Property(property="address", type="string", example="311 EDGEWATER DR,BLOOMINGDALE,IL,60108"),
     *                             @OA\Property(property="latitude", type="string", example="41.9432393"),
     *                             @OA\Property(property="longitude", type="string", example="-88.0654917"),
     *                             @OA\Property(property="distance", type="string", example=""),
     *                             @OA\Property(property="servicehub_name", type="string", example=""),
     *                             @OA\Property(property="checkout_option", type="integer", example=3),
     *                             @OA\Property(property="clientassetservicehubstatus", type="integer", example=0),
     *                             @OA\Property(property="clientassetservicehubaddress", type="string", example=""),
     *                             @OA\Property(property="clientassetservicehublatitude", type="string", example=""),
     *                             @OA\Property(property="clientassetservicehublongitude", type="string", example=""),
     *                             @OA\Property(property="clientasset_id", type="integer", example=0),
     *                             @OA\Property(property="Total_Orders", type="integer", example=1),
     *                             @OA\Property(property="Total_Orders1", type="integer", example=1),
     *                             @OA\Property(property="Total_collected", type="integer", example=0),
     *                             @OA\Property(property="Total_rejected", type="integer", example=0),
     *                             @OA\Property(property="drawfastingpicture", type="integer", example=0),
     *                             @OA\Property(property="drawtimepicture", type="integer", example=0),
     *                             @OA\Property(property="warningstatus", type="integer", example=0),
     *                             @OA\Property(property="withcourierstatus", type="integer", example=0),
     *                             @OA\Property(property="withcouriermessage", type="string", example=""),
     *                             @OA\Property(property="statusname", type="string", example="Assigned"),
     *                             @OA\Property(property="status", type="integer", example=0),
     *                             @OA\Property(property="couriercheckin", type="integer", example=0),
     *                             @OA\Property(property="newassignedorder", type="integer", example=0),
     *                             @OA\Property(property="donotallowcheckoutwithoutvalidation", type="integer", example=1),
     *                             @OA\Property(property="donotallowcheckoutwithoutvalidationmessage", type="string", example="Wait for admin Validation this facilities"),
     *                             @OA\Property(property="validationrejected", type="integer", example=0)
     *                         ),
     *                     ),
     *                 ),
     *         ),
     *     ),
     * )
     */
    public function dashboard(Request $request){
        $user_id = JWTAuth::user()->user_id;
        $jsonData = [
            'tech_id'=>$user_id,
            'mobile'=>true
        ];
        //return [$jsonData];
        // Convert array to JSON
        $jsonString = json_encode($jsonData);

        // API endpoint URL
        $apiUrl = $this->apiUrl.'offlinedata/dashboardorders';

        // return response()->json([
        //     'success' => true,
        //     'data' => $apiUrl,
        //     'json' => $jsonData
        // ]);

        // cURL initialization
        $ch = curl_init($apiUrl);

        // Set cURL options
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonString);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Content-Length: ' . strlen($jsonString),
        ]);

        // Execute cURL session and get the response
        $response = curl_exec($ch);

        // Check for cURL errors
        if (curl_errno($ch)) {
            // Handle error
            return response()->json(['success'=>false,'error'=>curl_error($ch)]);
        }

        // Close cURL session
        curl_close($ch);
        $responseData = json_decode($response, true);
        if(isset( $responseData['unreadmessages']))
            $responseData['unreadmessages'] = ($responseData['unreadmessages'] && $responseData['unreadmessages'] != '') ? +($responseData['unreadmessages']) : 0;
        // $response['unreadmessages']=$response['unreadmessages']?$response['unreadmessages']:0;
        return response()->json(['success'=>true,'error'=>'','data'=>$responseData,'json'=>$jsonData,'url'=>$apiUrl]);
    }

    /**
     * @OA\Post(
     *       path="/api/api-call-url",
     *     operationId="apicallurl",
     *     tags={"Protected Routes"},
     *     summary="Get List of apicallurl",
     *     description="This route requires authentication.",
     *     security={{"bearerAuth": {}}},
     *       @OA\RequestBody(
     *           required=true,
     *           @OA\MediaType(
     *               mediaType="application/json",
     *               @OA\Schema(
     *                   @OA\Property(property="data_request_array", type="array",
     *                       @OA\Items(type="object",
     *                           @OA\Property(property="action", type="string", example=""),
     *                           @OA\Property(property="method", type="string", example=""),
     *                           @OA\Property(property="data", type="string", example=""),
     *                           @OA\Property(property="timestamp", type="string", example=""),
     *                           @OA\Property(property="type", type="string", example=""),
     *                       ),
     *                   ),
     *               ),
     *           ),
     *       ),
     *       @OA\Response(
     *           response=200,
     *           description="Success",
     *           @OA\MediaType(
     *               mediaType="application/json",
     *               @OA\Schema(
     *                   @OA\Property(property="success", type="boolean", example="true"),
     *                   @OA\Property(property="error", type="string", example=""),
     *                   @OA\Property(property="data", type="array",
     *                       @OA\Items(type="object",
     *                           @OA\Property(property="any", type="any", example="")
     *                       ),
     *                   ),
     *               ),
     *           ),
     *       ),
     *   )
     */
    public function apiCallUrl(Request $request){
        $dataReq = $request->data_request_array;
        if(count($dataReq)>1){
            foreach ($dataReq as $key => $value) {
                $action = $value['action'];
                $requestData = json_encode($value['data']);

                // exception for track location action because v5 is being stupid
                if($action =='singulab/track_location')
                {
                    $method = 1;
                    $latitude= $value['data']['latitude'];
                    $longitude=$value['data']['longitude'];
                    $techId=$value['data']['tech_id'];

                    $action = $action."?&latitude=$latitude&longitude=$longitude&tech_id=$techId";


                }
                // end of exception for track location
                $apiUrl = $this->apiUrl.$action;
                $method = $value['method']==1 ? 1 : 0;
                $type = $value['type'];

                //dd(strlen($value['timestamp']));
                if(strlen($value['timestamp'])==13)
                {
                    $value['timestamp'] = $value['timestamp']/1000; // convert milliseconds to seconds
                    // dd($value['timestamp']);
                }

                $timestamp = $value['timestamp']?(Carbon::createFromTimestamp($value['timestamp'])->format('Y-m-d H:i:s')):Carbon::now()->format('Y-m-d H:i:s');
                $status = $value['type'] == 1 ? 1 : 0;
                $data = [
                    'endpoint' => $apiUrl,
                    'action' => $action,
                    'method' => $method,
                    'data' => $requestData,
                    'response' => null,
                    'timestamp' => $timestamp,
                    'type' => $type,
                    'status' => $status
                ];
                DataQueue::insert($data);
            }
            $response = ["success" => true, "error" => null,"data"=>null, "message" => "Syncronized Data Successfully"];
            return response()->json($response);
        }else if(count($dataReq)==1){
            $dataReq = $dataReq[0];
            $action = $dataReq['action'];

            $method = $dataReq['method']==1 ? 1 : 0;
            $type = $dataReq['type'];
            $requestData = json_encode($dataReq['data']);

            // exception for track location action because v5 is being stupid
            if($action =='singulab/track_location')
            {
                $method = 1;
                $latitude= $dataReq['data']['latitude'];
                $longitude=$dataReq['data']['longitude'];
                $techId=$dataReq['data']['tech_id'];

                $action = $action."?&latitude=$latitude&longitude=$longitude&tech_id=$techId";


            }
            // end of exception for track location
            $apiUrl = $this->apiUrl.$action;


            if(strlen($dataReq['timestamp'])==13)
            {
                $dataReq['timestamp'] = $dataReq['timestamp']/1000; // convert milliseconds to seconds

            }

            $timestamp = $dataReq['timestamp']?(Carbon::createFromTimestamp($dataReq['timestamp'])->format('Y-m-d H:i:s')):Carbon::now()->format('Y-m-d H:i:s');
            $status = ($dataReq['type'] == 1) ? 1 : 0;
            if($type == 1)
            {

                $response = $this->getCurlData($apiUrl,$method,$dataReq['data']);
                if($response['success'] == true){
                    $data = [
                        'endpoint' => $apiUrl,
                        'action' => $action,
                        'method' => $method,
                        'data' => $requestData,
                        'response' => json_encode($response['data']),
                        'timestamp' => $timestamp,
                        'type' => $type,
                        'status' => $status
                    ];
                    DataQueue::insert($data);
                }else{
                    $data = [
                        'endpoint' => $apiUrl,
                        'action' => $action,
                        'method' => $method,
                        'data' => $requestData,
                        'response' => null,
                        'timestamp' => $timestamp,
                        'type' => 0,
                        'status' => $status
                    ];
                    DataQueue::insert($data);
                }
                $response['request_body'] = $dataReq['data'];
                $response['request_url'] = $apiUrl;
                $response['request_method'] = $method==1?"POST":"GET";
                return response()->json($response);
            }else {
                $data = [
                    'endpoint' => $apiUrl,
                    'action' => $action,
                    'method' => $method,
                    'data' => $requestData,
                    'response' => null,
                    'timestamp' => $timestamp,
                    'type' => $type,
                    'status' => $status
                ];
                DataQueue::insert($data);
                // DataQueue::insert($dataReq);
                $response = ["success" => true, "error" => null,"data"=>null, "message" => "Syncronized Data Successfully"];
                return response()->json($response);
            }
        }else{
            $response = ["success" => false, "error" => 'Syncronized Data Failed',"data"=>null, "message" => null];
            return response()->json($response);
        }
        // return response()->json($response);
    }

    public function queueCheckAndExceute()
    {
        $dataQueue = DataQueue::where('status', 0)->get();
        foreach ($dataQueue as $key => $value) {
            $data = json_decode($value->data, true);
            $response = $this->getCurlData($value->endpoint, $value->method, $data);
            $updatedData = DataQueue::where('id', $value->id)->first();
            $updatedData->response = json_encode($response);
            $updatedData->timestamp = Carbon::now()->format('Y-m-d H:i:s');
            $updatedData->status = 1;
            $updatedData->save();
        }
        return true;
    }

    public function collectedOrders(Request $request){
        $user_id = JWTAuth::user()->user_id;
        $jsonData = [
            'tech_id'=>$user_id,
            'mobile'=>true
        ];

        // Convert array to JSON
        $jsonString = json_encode($jsonData);

        // API endpoint URL
        $apiUrl = $this->apiUrl.'singulab/Allcollectedorder';

        // cURL initialization
        $ch = curl_init($apiUrl);

        // Set cURL options
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonString);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Content-Length: ' . strlen($jsonString),
        ]);

        // Execute cURL session and get the response
        $response = curl_exec($ch);

        // Check for cURL errors
        if (curl_errno($ch)) {
            // Handle error
            return response()->json(['success'=>false,'error'=>curl_error($ch)]);
        }

        // Close cURL session
        curl_close($ch);
        $responseData = json_decode($response, true);
        if(isset( $responseData['unreadmessages']))
            $responseData['unreadmessages'] = ($responseData['unreadmessages'] && $responseData['unreadmessages'] != '') ? +($responseData['unreadmessages']) : 0;

        return response()->json(['success'=>true,'error'=>'','data'=>$responseData,'json'=>$jsonData,'url'=>$apiUrl]);
    }
    
    
    public function collectedOrdersWithDaterange(Request $request){
        $user_id = JWTAuth::user()->user_id;
        $jsonData = [
            'mobile'=>true,
            'tech_id'=>$user_id,
            'start_date' => $request->input('start_date'),
            'end_date' => $request->input('end_date'),
            'date' => $request->input('date')
        ];

        // Convert array to JSON
        $jsonString = json_encode($jsonData);

        // API endpoint URL
        $apiUrl = $this->apiUrl.'singulab/collected-date-range';

        // cURL initialization
        $ch = curl_init($apiUrl);

        // Set cURL options
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonString);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Content-Length: ' . strlen($jsonString),
        ]);

        // Execute cURL session and get the response
        $response = curl_exec($ch);

        // Check for cURL errors
        if (curl_errno($ch)) {
            // Handle error
            return response()->json(['success'=>false,'error'=>curl_error($ch)]);
        }

        // Close cURL session
        curl_close($ch);
        $responseData = json_decode($response, true);
        if(isset( $responseData['unreadmessages']))
            $responseData['unreadmessages'] = ($responseData['unreadmessages'] && $responseData['unreadmessages'] != '') ? +($responseData['unreadmessages']) : 0;

        return response()->json(['success'=>true,'error'=>'','data'=>$responseData,'json'=>$jsonData,'url'=>$apiUrl]);
    }

    public function completedOrders(Request $request){
        $user_id = JWTAuth::user()->user_id;
        $jsonData = [
            'tech_id'=>$user_id,
            'mobile'=>true
        ];

        // Convert array to JSON
        $jsonString = json_encode($jsonData);

        // API endpoint URL
        $apiUrl = $this->apiUrl.'singulab/completed-orders-list';

        // cURL initialization
        $ch = curl_init($apiUrl);

        // Set cURL options
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonString);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Content-Length: ' . strlen($jsonString),
        ]);

        // Execute cURL session and get the response
        $response = curl_exec($ch);

        // Check for cURL errors
        if (curl_errno($ch)) {
            // Handle error
            return response()->json(['success'=>false,'error'=>curl_error($ch)]);
        }

        // Close cURL session
        curl_close($ch);
        $responseData = json_decode($response, true);
        if(isset( $responseData['unreadmessages']))
            $responseData['unreadmessages'] = ($responseData['unreadmessages'] && $responseData['unreadmessages'] != '') ? +($responseData['unreadmessages']) : 0;

        return response()->json(['success'=>true,'error'=>'','data'=>$responseData,'json'=>$jsonData,'url'=>$apiUrl]);
    }

    public function patientzplfile(Request $request) {
        $apiUrl = $this->apiUrl.'singulab/patientzplfile';

        // Data to send
        $jsonData = [
            'client_id' => $request->input('client_id'),
            'patient_id' => $request->input('patient_id'),
            'tech_id' => $request->input('tech_id')
        ];

        $jsonString = json_encode($jsonData);

        $ch = curl_init($apiUrl);

        // Set cURL options
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonString);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Content-Length: ' . strlen($jsonString),
        ]);

        // Optional: Disable SSL verification if you're in development mode
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        $response = curl_exec($ch);

        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $curlError = curl_error($ch);

        curl_close($ch);
        

        if ($response === false || empty($response)) {
            return response()->json([
                'success' => false,
                'error' => 'No response or null data received from API.',
                'http_code' => $httpCode,
                'curl_error' => $curlError,
                'raw_response' => $response
            ]);
        }

        $responseData = json_decode($response, true);
        $linkContent="";
        if(isset($responseData['link']))
        {
             $link = $responseData['link'];
              $linkContent=file_get_contents($link);
        }
       $responseData['link_content']=$linkContent;

        return response()->json([
            'success' => true,
            'data' => $responseData
        ]);
    }

    public function zplfilebkp(Request $request) {
        $apiUrl = $this->apiUrl.'singulab/zplfile';

        $jsonData = [
            'order_id' => $request->input('order_id')
        ];

        $jsonString = json_encode($jsonData);

        $ch = curl_init($apiUrl);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonString);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Content-Length: ' . strlen($jsonString),
        ]);

        // Optional: Disable SSL verification if you're in development mode
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        $response = curl_exec($ch);

        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $curlError = curl_error($ch);

        curl_close($ch);

        if ($response === false || empty($response)) {
            return response()->json([
                'success' => false,
                'error' => 'No response or null data received from API.',
                'http_code' => $httpCode,
                'curl_error' => $curlError,
                'raw_response' => $response
            ]);
        }

        $responseData = json_decode($response, true);
        $linkContent="";
        if(isset($responseData['link']))
        {
             $link = $responseData['link'];
              $linkContent=file_get_contents($link);
        }
       $responseData['link_content']=$linkContent;


        return response()->json([
            'success' => true,
            'data' => $responseData
        ]);
    }

    public function zplfile(Request $request) {
        $apiUrl = $this->apiUrl.'singulab/zplfile';

        $jsonData = [
            'order_id' => $request->input('order_id')
        ];

        $jsonString = json_encode($jsonData);

        $ch = curl_init($apiUrl);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonString);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Content-Length: ' . strlen($jsonString),
        ]);

        // Optional: Disable SSL verification if you're in development mode
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        $response = curl_exec($ch);

        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $curlError = curl_error($ch);

        curl_close($ch);

        if ($response === false || empty($response)) {
            return response()->json([
                'success' => false,
                'error' => 'No response or null data received from API.',
                'http_code' => $httpCode,
                'curl_error' => $curlError,
                'raw_response' => $response
            ]);
        }

        $responseData = json_decode($response, true);
        $linkContent="";
        if(isset($responseData['link']))
        {
            $link = $responseData['link'];
            $linkContent=file_get_contents($link);
        }
        $responseData['link_content']=$linkContent;

        // if (!isset($responseData['files']) || empty($responseData['files'])) {
        //     return response()->json([
        //         'success' => false,
        //         'error' => 'No files generated or empty response from API.',
        //         'http_code' => $httpCode,
        //         'response' => $responseData
        //     ]);
        // }

        // Process each file link and fetch its content
        $fileContents = [];
        if(isset($responseData['files'])){
            $files = $responseData['files'];
            foreach ($files as $file) {
                if (isset($file['link'])) {
                    $filelink = $file['link'];
                    $fileContent = @file_get_contents($filelink);
                    if ($fileContent !== false) {
                        $fileContents[] = [
                            'filename' => $file['filename'],
                            'content' => $fileContent
                        ];
                    } else {
                        $fileContents[] = [
                            'filename' => $file['filename'],
                            'content' => 'Failed to fetch file content'
                        ];
                    }
                }
            }
        }

        $responseData['labels'] = $fileContents;



        return response()->json([
            'success' => true,
            'data' => $responseData
        ]);
    }
}
