<?php

namespace App\Http\Controllers;

use App\Models\Diagnosiscode;
use Carbon\Carbon;
use Illuminate\Http\Request;


ini_set('max_input_vars', 100000);
ini_set('max_execution_time', 100000);
ini_set('mysql.connect_timeout', 100000);
ini_set('default_socket_timeout', 100000);
ini_set('memory_limit', '-1');

class DiagnosiscodeController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:api');
    }
    /**
     * @OA\Post(
     *     path="/api/dxcode/getlist",
     *     operationId="dxcodegetList",
     *     tags={"Protected Routes"},
     *     summary="Get List of DXCodes",
     *     description="This route requires authentication. Retrieves a list of DXCodes with details on added, updated, and deleted items.",
     *     security={{"bearerAuth": {}}},
     *     @OA\RequestBody(
     *         required=true,
     *         description="User credentials",
     *         @OA\JsonContent(
     *             @OA\Property(property="timestamp", type="string", format="timestamp", example=1828384884)
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Successful response",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="success", type="boolean", example=true),
     *             @OA\Property(property="added", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="id", type="integer", example=1),
     *                     @OA\Property(property="diagnosis_code", type="string", example="A000"),
     *                     @OA\Property(property="diagnosis_description", type="string", example="Cholera due to Vibrio cholerae 01, biovar cholerae"),
     *                     @OA\Property(property="status", type="integer", example=1),
     *                     @OA\Property(property="deleted_at", type="string", nullable=true, example="1970-07-07 12:37:07/null"),
     *                     @OA\Property(property="lastupdated_datetimestamp", type="string", example="1970-07-07 12:37:07"),
     *                     @OA\Property(property="subscriber_id", type="integer", nullable=true),
     *                     @OA\Property(property="delete_by", type="integer", nullable=true),
     *                 ),
     *             ),
     *             @OA\Property(property="updated", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="id", type="integer", example=1),
     *                     @OA\Property(property="diagnosis_code", type="string", example="A000"),
     *                     @OA\Property(property="diagnosis_description", type="string", example="Cholera due to Vibrio cholerae 01, biovar cholerae"),
     *                     @OA\Property(property="status", type="integer", example=1),
     *                     @OA\Property(property="deleted_at", type="string", nullable=true, example="1970-07-07 12:37:07/null"),
     *                     @OA\Property(property="lastupdated_datetimestamp", type="string", example="1970-07-07 12:37:07"),
     *                     @OA\Property(property="subscriber_id", type="integer", nullable=true),
     *                     @OA\Property(property="delete_by", type="integer", nullable=true),
     *                 ),
     *             ),
     *             @OA\Property(property="deleted", type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="id", type="integer", example=1),
     *                     @OA\Property(property="diagnosis_code", type="string", example="A000"),
     *                     @OA\Property(property="diagnosis_description", type="string", example="Cholera due to Vibrio cholerae 01, biovar cholerae"),
     *                     @OA\Property(property="status", type="integer", example=1),
     *                     @OA\Property(property="deleted_at", type="string", nullable=true, example="1970-07-07 12:37:07/null"),
     *                     @OA\Property(property="lastupdated_datetimestamp", type="string", example="1970-07-07 12:37:07"),
     *                     @OA\Property(property="subscriber_id", type="integer", nullable=true),
     *                     @OA\Property(property="delete_by", type="integer", nullable=true),
     *                 ),
     *             ),
     *         ),
     *     ),
     * )
     */
    public function getList(Request $request){
        $currentTimeStamp = $request->timestamp ? Carbon::createFromTimestamp($request->timestamp)->format('Y-m-d') : null;
        $added = [];
        $updated = [];
        $deleted = [];
        if($currentTimeStamp){
            $addedIDs = Diagnosiscode::whereNull('deleted_at')
                        ->whereDate('created_at', '>=', $currentTimeStamp)
                        ->pluck('id');

            $updated = Diagnosiscode::whereNotIn('id',$addedIDs)
                    ->whereNull('deleted_at')
                    ->whereDate('lastupdated_datetimestamp','>=',$currentTimeStamp)
                    ->select("id", "diagnosis_code", "diagnosis_description", "status", "deleted_at", "lastupdated_datetimestamp", "subscriber_id", "delete_by")
                    ->get();

            $deleted = Diagnosiscode::whereNotNull('deleted_at')
                    ->whereDate('lastupdated_datetimestamp','>=',$currentTimeStamp)
                    ->select("id", "diagnosis_code", "diagnosis_description", "status", "deleted_at", "lastupdated_datetimestamp", "subscriber_id", "delete_by")
                    ->get();
        }else{
            $added = Diagnosiscode::whereNull('deleted_at')
                    ->select("id", "diagnosis_code", "diagnosis_description", "status", "deleted_at", "lastupdated_datetimestamp", "subscriber_id", "delete_by")
                    ->get();

            $deleted = Diagnosiscode::whereNotNull('deleted_at')
                    ->select("id", "diagnosis_code", "diagnosis_description", "status", "deleted_at", "lastupdated_datetimestamp", "subscriber_id", "delete_by")
                    ->get();
        }
        return ['success'=>true,"added"=>$added, "updated"=>$updated, "deleted"=>$deleted];
    }
}
