<?php

namespace App\Http\Controllers;

use App\Models\Appointmenttime;
use App\Models\Client;
use App\Models\Clientasset;
use App\Models\Diagnosiscode;
use App\Models\Insurance;
use App\Models\Laboratory;
use App\Models\Labtest;
use App\Models\Patient;
use App\Models\Provider;
use App\Models\RejectReason;
use App\Models\ServiceHub;
use App\Models\Technician;
use App\Models\Testtube;
use Carbon\Carbon;
use Illuminate\Http\Request;

class ApiUpdateCheckController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:api');
    }
    /**
     * @OA\Post(
     *     path="/api/api-update-check",
     *     operationId="apiUpdateCheck",
     *     tags={"Protected Routes"},
     *     summary="Get List of apiUpdateCheck",
     *     description="This route requires authentication. Retrieves a list of apiUpdateCheck.",
     *     security={{"bearerAuth": {}}},
     *     @OA\RequestBody(
     *         required=true,
     *         description="User credentials",
     *         @OA\JsonContent(
     *             @OA\Property(property="timestamp", type="string", format="timestamp", example=1828384884)
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Successful response if true then call related api",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="success", type="boolean", example=true),
     *             @OA\Property(property="dxcode", type="boolean", example=true),
     *             @OA\Property(property="labtest", type="boolean", example=true),
     *             @OA\Property(property="laboratory", type="boolean", example=true),
     *             @OA\Property(property="testtube", type="boolean", example=true),
     *             @OA\Property(property="rejectreason", type="boolean", example=true),
     *             @OA\Property(property="insurance", type="boolean", example=true),
     *             @OA\Property(property="technician", type="boolean", example=true),
     *             @OA\Property(property="servicehub", type="boolean", example=true),
     *             @OA\Property(property="patient", type="boolean", example=true),
     *             @OA\Property(property="client", type="boolean", example=true),
     *             @OA\Property(property="clientasset", type="boolean", example=true)
     *         ),
     *     ),
     * )
     */
    public function apiUpdateCheck(Request $request){
        $updateTime = $request->timestamp ? Carbon::createFromTimestamp($request->timestamp)->format('Y-m-d H:i:s') : null;

        if($updateTime){
            $appointmenttime = true;
            $dxcode = false;
            $labtest = false;
            $laboratory = false;
            $testtube = false;
            $rejectreason = false;
            $insurance = false;
            $technician = false;
            $servicehub = false;
            $patient = false;
            $client = false;
            $clientasset = false;
            $provider = false;
            $DiagnosiscodeArray = Diagnosiscode::where('lastupdated_datetimestamp','>=',$updateTime)->count();
            $AppointmentTimeArray = Appointmenttime::where('updated_at','>=',$updateTime)->count();
            $LabtestArray = Labtest::where('updated_at','>=',$updateTime)->count();
            $LaboratoryArray = Laboratory::where('updated_at','>=',$updateTime)->count();
            $TesttubeArray = Testtube::where('updated_at','>=',$updateTime)->count();
            $RejectReasonArray = RejectReason::where('updated_at','>=',$updateTime)->count();
            $InsuranceArray = Insurance::where('updated_at','>=',$updateTime)->count();
            $TechnicianArray = Technician::where('updated_at','>=',$updateTime)->count();
            $ServiceHubArray = ServiceHub::where('updated_at','>=',$updateTime)->count();
            $PatientArray = Patient::where('updated_at','>=',$updateTime)->count();
            $ClientArray = Client::where('updated_at','>=',$updateTime)->count();
            $ProviderArray = Provider::where('updated_at','>=',$updateTime)->count();
            $clientassetArray = 0;//Clientasset::where('updated_at','>=',$updateTime)->count();

            if($AppointmentTimeArray > 0) {
                $appointmenttime = true;
            }
            if($DiagnosiscodeArray > 0) {
                $dxcode = true;
            }
            if($LabtestArray > 0) {
                $labtest = true;
            }
            if($LaboratoryArray > 0) {
                $laboratory = true;
            }
            if($TesttubeArray > 0) {
                $testtube = true;
            }
            if($RejectReasonArray > 0) {
                $rejectreason = true;
            }
            if($InsuranceArray > 0) {
                $insurance = true;
            }
            if($TechnicianArray > 0) {
                $technician = true;
            }
            if($ServiceHubArray > 0) {
                $servicehub = true;
            }
            if($PatientArray > 0) {
                $patient = true;
            }
            if($ClientArray > 0) {
                $client = true;
            }
            if($clientassetArray > 0) {
                $clientasset = true;
            }
            if($ProviderArray > 0) {
                $provider = true;
            }
            return response()->json([
                'success'=>true,
                'appointmenttime'=>$appointmenttime,
                'dxcode'=>$dxcode,
                'labtest'=>$labtest,
                'laboratory'=>$laboratory,
                'testtube'=>$testtube,
                'rejectreason'=>$rejectreason,
                'insurance'=>$insurance,
                'technician'=>$technician,
                'servicehub'=>$servicehub,
                'patient'=>$patient,
                'client'=>$client,
                'clientasset'=>$clientasset,
                'provider'=>$provider
            ]);
        }
        return response()->json([
            'success'=>true,
            'appointmenttime'=>true,
            'dxcode'=>true,
            'labtest'=>true,
            'laboratory'=>true,
            'testtube'=>true,
            'rejectreason'=>true,
            'insurance'=>true,
            'technician'=>true,
            'servicehub'=>true,
            'patient'=>true,
            'client'=>true,
            'clientasset'=>true,
            'provider'=>true
        ]);
    }
}
